package gov.va.med.mhv.bluebutton.bbmi.imaging.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CVIXDateUtil {

	static private String formats[] = null;

	static {
		// 10/13/2010 13:36:56, 01/26/2009 14:25
		formats = new String[] {"yyyy-MM-dd'T'HH:mm:ssZ",
								"MM/dd/yyyy HH:mm:ss", 
								"MM/dd/yyyy HH:mm", 
								"MM/dd/yyyy" };
	}

	public static Date parseDate(String dateString) throws Exception {
		Date result = null;
		String format = null;

		assert (dateString != null);

		//System.out.println("Formatting date '" + dateString + "'");
		StringBuffer sb = new StringBuffer(dateString);
		if( dateString.lastIndexOf(':') == dateString.length()-3 ) {
			sb.deleteCharAt(dateString.lastIndexOf(':'));
			//System.out.println(">"+sb);
			dateString=sb.toString();
		}
		
		for (String f : formats) {
			try {
				DateFormat df = new SimpleDateFormat(f);
				df.setLenient(false);
				result = df.parse(dateString.trim());
				// System.out.println("Using date format '" + f + "'" + " for '"
				// + dateString.trim() + "'");
				format = f;
				break;
			} catch (ParseException e) {
				// e.printStackTrace();
			}
		}
		if (null == result) {
			System.err.println("Unable to parse value '" + dateString + "'");
		}

		if (null != result) {
			Calendar c = Calendar.getInstance();
			c.setTime(result);
			if (c.get(Calendar.YEAR) < 1000) {
				throw new Exception("Invalid date '" + dateString + "'");
			}
		}

		// Lastly set the time to 12pm to avoid daylight saving adjustments
		if (null != result && null!= format && !format.contains("HH")) {
			Calendar c = Calendar.getInstance();
			c.setTime(result);
			c.set(Calendar.HOUR, 0);
			c.set(Calendar.MINUTE, 0);
			c.set(Calendar.SECOND, 0);
			c.set(Calendar.AM_PM, Calendar.PM);
			result = c.getTime();
		}

		return result;
	}

//	public static void main(String[] args) {
//		try {
//			System.out.println(parseDate("12/12/2014 00:00:00"));
//			System.out.println(parseDate("12/12/2014 00:00"));
//			System.out.println(parseDate("12/12/2014"));
//			System.out.println(parseDate("2007-05-23T00:01:00-04:00"));
//
//			Date today = new Date();
//			Date d = parseDate("07/14/2014 15:13");
//			System.out.println("today=" + today);
//			System.out.println("d=" + d);
//
//			System.out.println("Future?" + d.after(today));
//
//		} catch (Exception e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	}

}